//
//  MCStackView.h
//  MCApplication
//
//  Created by Ali Lalani on Thu Jul 29 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "NSSplitView+ExposePrivate.h"
#import "MCStackViewDefines.h"
#import "MCMainWindowCanvas.h"
#import "MCDisplayStateProtocol.h"
#import "MCMenuManagerSupportProtocol.h"

#import <MCFoundation/MCSourceList.h>

#import <MCApplication/MCSplitView.h>

@class MCStackPane;

@interface MCStackView : MCSplitView <MCMainWindowCanvas,MCDisplayState,MCMenuManagerSupport> {
	NSMutableArray *collapsedSubviews;

	int mouseDownInDivider;
	float collapsedSubviewHeight;
	
	float animationPercentDone;
	BOOL isAnimating;

	float collapsedHeight;

	NSString *_identifier;

	id <MCSourceList> sourceList;
	NSArray *sourceLists;
	NSArray *selectedResults;

	// DISPLAY STATE
	NSMutableDictionary *displayState;
	id                   displayStateDelegate;

	id document;

    BOOL _shouldRefresh;
}
+ (MCStackView *)stackViewWithFrame:(NSRect)aRect panes:(NSArray *)panes;

- (void)toggleCollapsedStateForSubview:(MCStackPane *)aSubview;
- (void)collapseSubview:(MCStackPane *)aSubview animate:(BOOL)flag;
- (void)expandSubview:(MCStackPane *)aSubview;
- (BOOL)isAnimating;
- (float)animationPercentDone;

// Refresh the source list
- (IBAction)refresh:(id)sender;


// Split view handling stuff
- (NSView *)subviewForDividerRect:(NSRect)aRect;
- (NSRect)dividerRectForPoint:(NSPoint)aPoint;
- (NSArray *)splitterRects;
- (BOOL)mcIsSubviewCollapsed:(NSView *)aSubview;
- (int)dividerOffsetForPoint:(NSPoint)aPoint;
- (float)moveDividerAtOffset:(int)offset draggingOffset:(int)dragOffset toYCoord:(float)proposedYCoord delta:(float)delta;
- (void)setSubview:(NSView *)aView collapsed:(BOOL)flag;
- (void)moveDivider:(int)offset subview:(MCStackPane *)pane toCoordinate:(float)coordinate moveProximalDividers:(NSArray *)proximalDividers
			animate:(BOOL)flag;

// Config
- (void)configure;
- (void)setIdentifier:(NSString *)anIdentifier;
- (NSString *)identifier;

// Accessors
- (float)collapsedSubviewHeight;
- (NSArray *)selectedResults;

#pragma mark DisplayStateReadWrite
- (void)readSplitViewStateFromDisplayState;
- (void)writeSplitViewStateToDisplayState;
@end
